@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connection provider parameters
 * @property oAuthSettings OAuth settings for the connection provider
 * @property type Type of the parameter
 */
public data class ConnectionParameterResponse(
    public val oAuthSettings: ApiOAuthSettingsResponse? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ConnectionParameterResponse): ConnectionParameterResponse = ConnectionParameterResponse(
            oAuthSettings = javaType.oAuthSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ApiOAuthSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
