@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connection status
 * @property error Connection error
 * @property status The gateway status
 * @property target Target of the error
 */
public data class ConnectionStatusDefinitionResponse(
    public val error: ConnectionErrorResponse? = null,
    public val status: String? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ConnectionStatusDefinitionResponse): ConnectionStatusDefinitionResponse = ConnectionStatusDefinitionResponse(
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ConnectionErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
