@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appSubnetResourceId Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
 * @property controlPlaneSubnetResourceId Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
 * @property daprAIInstrumentationKey Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
 * @property dockerBridgeCidr CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
 * @property platformReservedCidr IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
 * @property platformReservedDnsIP An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
 */
public data class ContainerAppsConfigurationResponse(
    public val appSubnetResourceId: String? = null,
    public val controlPlaneSubnetResourceId: String? = null,
    public val daprAIInstrumentationKey: String? = null,
    public val dockerBridgeCidr: String? = null,
    public val platformReservedCidr: String? = null,
    public val platformReservedDnsIP: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ContainerAppsConfigurationResponse): ContainerAppsConfigurationResponse = ContainerAppsConfigurationResponse(
            appSubnetResourceId = javaType.appSubnetResourceId().map({ args0 -> args0 }).orElse(null),
            controlPlaneSubnetResourceId = javaType.controlPlaneSubnetResourceId().map({ args0 ->
                args0
            }).orElse(null),
            daprAIInstrumentationKey = javaType.daprAIInstrumentationKey().map({ args0 -> args0 }).orElse(null),
            dockerBridgeCidr = javaType.dockerBridgeCidr().map({ args0 -> args0 }).orElse(null),
            platformReservedCidr = javaType.platformReservedCidr().map({ args0 -> args0 }).orElse(null),
            platformReservedDnsIP = javaType.platformReservedDnsIP().map({ args0 -> args0 }).orElse(null),
        )
    }
}
