@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Container App container resource requirements.
 * @property cpu Required CPU in cores, e.g. 0.5
 * @property memory Required memory, e.g. "250Mb"
 */
public data class ContainerResourcesResponse(
    public val cpu: Double? = null,
    public val memory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ContainerResourcesResponse): ContainerResourcesResponse = ContainerResourcesResponse(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
