@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Container App container Custom scaling rule.
 * @property auth Authentication secrets for the custom scale rule.
 * @property metadata Metadata properties to describe custom scale rule.
 * @property type Type of the custom scale rule
 * eg: azure-servicebus, redis etc.
 */
public data class CustomScaleRuleResponse(
    public val auth: List<ScaleRuleAuthResponse>? = null,
    public val metadata: Map<String, String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.CustomScaleRuleResponse): CustomScaleRuleResponse = CustomScaleRuleResponse(
            auth = javaType.auth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ScaleRuleAuthResponse.Companion.toKotlin(args0)
                })
            }),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
