@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Dapr component configuration
 * @property metadata Component metadata
 * @property name Component name
 * @property type Component type
 * @property version Component version
 */
public data class DaprComponentResponse(
    public val metadata: List<DaprMetadataResponse>? = null,
    public val name: String? = null,
    public val type: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.DaprComponentResponse): DaprComponentResponse = DaprComponentResponse(
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.DaprMetadataResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
