@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container App Dapr component metadata.
 * @property name Metadata property name.
 * @property secretRef Name of the Container App secret from which to pull the metadata property value.
 * @property value Metadata property value.
 */
public data class DaprMetadataResponse(
    public val name: String? = null,
    public val secretRef: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.DaprMetadataResponse): DaprMetadataResponse = DaprMetadataResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            secretRef = javaType.secretRef().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
