@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Static Site Database Connection overview.
 * @property configurationFiles A list of configuration files associated with this database connection.
 * @property connectionIdentity If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
 * @property name If present, the name of this database connection resource.
 * @property region The region of the database resource.
 * @property resourceId The resource id of the database.
 */
public data class DatabaseConnectionOverviewResponse(
    public val configurationFiles: List<StaticSiteDatabaseConnectionConfigurationFileOverviewResponse>,
    public val connectionIdentity: String,
    public val name: String,
    public val region: String,
    public val resourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.DatabaseConnectionOverviewResponse): DatabaseConnectionOverviewResponse = DatabaseConnectionOverviewResponse(
            configurationFiles = javaType.configurationFiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.StaticSiteDatabaseConnectionConfigurationFileOverviewResponse.Companion.toKotlin(args0)
                })
            }),
            connectionIdentity = javaType.connectionIdentity(),
            name = javaType.name(),
            region = javaType.region(),
            resourceId = javaType.resourceId(),
        )
    }
}
