@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Http logs to file system configuration.
 * @property enabled True if configuration is enabled, false if it is disabled and null if configuration is not set.
 * @property retentionInDays Retention in days.
 * Remove files older than X days.
 * 0 or lower means no retention.
 * @property retentionInMb Maximum size in megabytes that http log files can use.
 * When reached old log files will be removed to make space for new ones.
 * Value can range between 25 and 100.
 */
public data class FileSystemHttpLogsConfigResponse(
    public val enabled: Boolean? = null,
    public val retentionInDays: Int? = null,
    public val retentionInMb: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.FileSystemHttpLogsConfigResponse): FileSystemHttpLogsConfigResponse = FileSystemHttpLogsConfigResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            retentionInDays = javaType.retentionInDays().map({ args0 -> args0 }).orElse(null),
            retentionInMb = javaType.retentionInMb().map({ args0 -> args0 }).orElse(null),
        )
    }
}
