@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the storage of the tokens if a file system is used.
 * @property directory The directory in which the tokens will be stored.
 */
public data class FileSystemTokenStoreResponse(
    public val directory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.FileSystemTokenStoreResponse): FileSystemTokenStoreResponse = FileSystemTokenStoreResponse(
            directory = javaType.directory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
