@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * App Service plan.
 * @property elasticScaleEnabled ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku
 * @property extendedLocation Extended Location.
 * @property freeOfferExpirationTime The time when the server farm free offer expires.
 * @property geoRegion Geographical location for the App Service plan.
 * @property hostingEnvironmentProfile Specification for the App Service Environment to use for the App Service plan.
 * @property hyperV If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
 * @property id Resource Id.
 * @property isSpot If <code>true</code>, this App Service Plan owns spot instances.
 * @property isXenon Obsolete: If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
 * @property kind Kind of resource.
 * @property kubeEnvironmentProfile Specification for the Kubernetes Environment to use for the App Service plan.
 * @property location Resource Location.
 * @property maximumElasticWorkerCount Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
 * @property maximumNumberOfWorkers Maximum number of instances that can be assigned to this App Service plan.
 * @property name Resource Name.
 * @property numberOfSites Number of apps assigned to this App Service plan.
 * @property numberOfWorkers The number of instances that are assigned to this App Service plan.
 * @property perSiteScaling If <code>true</code>, apps assigned to this App Service plan can be scaled independently.
 * If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.
 * @property provisioningState Provisioning state of the App Service Plan.
 * @property reserved If Linux app service plan <code>true</code>, <code>false</code> otherwise.
 * @property resourceGroup Resource group of the App Service plan.
 * @property sku Description of a SKU for a scalable resource.
 * @property spotExpirationTime The time when the server farm expires. Valid only if it is a spot server farm.
 * @property status App Service plan status.
 * @property subscription App Service plan subscription.
 * @property tags Resource tags.
 * @property targetWorkerCount Scaling worker count.
 * @property targetWorkerSizeId Scaling worker size ID.
 * @property type Resource type.
 * @property workerTierName Target worker tier assigned to the App Service plan.
 * @property zoneRedundant If <code>true</code>, this App Service Plan will perform availability zone balancing.
 * If <code>false</code>, this App Service Plan will not perform availability zone balancing.
 */
public data class GetAppServicePlanResult(
    public val elasticScaleEnabled: Boolean? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val freeOfferExpirationTime: String? = null,
    public val geoRegion: String,
    public val hostingEnvironmentProfile: HostingEnvironmentProfileResponse? = null,
    public val hyperV: Boolean? = null,
    public val id: String,
    public val isSpot: Boolean? = null,
    public val isXenon: Boolean? = null,
    public val kind: String? = null,
    public val kubeEnvironmentProfile: KubeEnvironmentProfileResponse? = null,
    public val location: String,
    public val maximumElasticWorkerCount: Int? = null,
    public val maximumNumberOfWorkers: Int,
    public val name: String,
    public val numberOfSites: Int,
    public val numberOfWorkers: Int,
    public val perSiteScaling: Boolean? = null,
    public val provisioningState: String,
    public val reserved: Boolean? = null,
    public val resourceGroup: String,
    public val sku: SkuDescriptionResponse? = null,
    public val spotExpirationTime: String? = null,
    public val status: String,
    public val subscription: String,
    public val tags: Map<String, String>? = null,
    public val targetWorkerCount: Int? = null,
    public val targetWorkerSizeId: Int? = null,
    public val type: String,
    public val workerTierName: String? = null,
    public val zoneRedundant: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetAppServicePlanResult): GetAppServicePlanResult = GetAppServicePlanResult(
            elasticScaleEnabled = javaType.elasticScaleEnabled().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            freeOfferExpirationTime = javaType.freeOfferExpirationTime().map({ args0 -> args0 }).orElse(null),
            geoRegion = javaType.geoRegion(),
            hostingEnvironmentProfile = javaType.hostingEnvironmentProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.HostingEnvironmentProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hyperV = javaType.hyperV().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isSpot = javaType.isSpot().map({ args0 -> args0 }).orElse(null),
            isXenon = javaType.isXenon().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            kubeEnvironmentProfile = javaType.kubeEnvironmentProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.KubeEnvironmentProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            maximumElasticWorkerCount = javaType.maximumElasticWorkerCount().map({ args0 ->
                args0
            }).orElse(null),
            maximumNumberOfWorkers = javaType.maximumNumberOfWorkers(),
            name = javaType.name(),
            numberOfSites = javaType.numberOfSites(),
            numberOfWorkers = javaType.numberOfWorkers(),
            perSiteScaling = javaType.perSiteScaling().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            reserved = javaType.reserved().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.SkuDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            spotExpirationTime = javaType.spotExpirationTime().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            subscription = javaType.subscription(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetWorkerCount = javaType.targetWorkerCount().map({ args0 -> args0 }).orElse(null),
            targetWorkerSizeId = javaType.targetWorkerSizeId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            workerTierName = javaType.workerTierName().map({ args0 -> args0 }).orElse(null),
            zoneRedundant = javaType.zoneRedundant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
