@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * SSL certificate for an app.
 * @property canonicalName CNAME of the certificate to be issued via free certificate
 * @property cerBlob Raw bytes of .cer file
 * @property domainValidationMethod Method of domain validation for free cert
 * @property expirationDate Certificate expiration date.
 * @property friendlyName Friendly name of the certificate.
 * @property hostNames Host names the certificate applies to.
 * @property hostingEnvironmentProfile Specification for the App Service Environment to use for the certificate.
 * @property id Resource Id.
 * @property issueDate Certificate issue Date.
 * @property issuer Certificate issuer.
 * @property keyVaultId Key Vault Csm resource Id.
 * @property keyVaultSecretName Key Vault secret name.
 * @property keyVaultSecretStatus Status of the Key Vault secret.
 * @property kind Kind of resource.
 * @property location Resource Location.
 * @property name Resource Name.
 * @property pfxBlob Pfx blob.
 * @property publicKeyHash Public key hash.
 * @property selfLink Self link.
 * @property serverFarmId Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
 * @property siteName App name.
 * @property subjectName Subject name of the certificate.
 * @property tags Resource tags.
 * @property thumbprint Certificate thumbprint.
 * @property type Resource type.
 * @property valid Is the certificate valid?.
 */
public data class GetCertificateResult(
    public val canonicalName: String? = null,
    public val cerBlob: String,
    public val domainValidationMethod: String? = null,
    public val expirationDate: String,
    public val friendlyName: String,
    public val hostNames: List<String>? = null,
    public val hostingEnvironmentProfile: HostingEnvironmentProfileResponse,
    public val id: String,
    public val issueDate: String,
    public val issuer: String,
    public val keyVaultId: String? = null,
    public val keyVaultSecretName: String? = null,
    public val keyVaultSecretStatus: String,
    public val kind: String? = null,
    public val location: String,
    public val name: String,
    public val pfxBlob: String? = null,
    public val publicKeyHash: String,
    public val selfLink: String,
    public val serverFarmId: String? = null,
    public val siteName: String,
    public val subjectName: String,
    public val tags: Map<String, String>? = null,
    public val thumbprint: String,
    public val type: String,
    public val valid: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetCertificateResult): GetCertificateResult = GetCertificateResult(
            canonicalName = javaType.canonicalName().map({ args0 -> args0 }).orElse(null),
            cerBlob = javaType.cerBlob(),
            domainValidationMethod = javaType.domainValidationMethod().map({ args0 -> args0 }).orElse(null),
            expirationDate = javaType.expirationDate(),
            friendlyName = javaType.friendlyName(),
            hostNames = javaType.hostNames().map({ args0 -> args0 }),
            hostingEnvironmentProfile = javaType.hostingEnvironmentProfile().let({ args0 ->
                com.pulumi.azurenative.web.kotlin.outputs.HostingEnvironmentProfileResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            issueDate = javaType.issueDate(),
            issuer = javaType.issuer(),
            keyVaultId = javaType.keyVaultId().map({ args0 -> args0 }).orElse(null),
            keyVaultSecretName = javaType.keyVaultSecretName().map({ args0 -> args0 }).orElse(null),
            keyVaultSecretStatus = javaType.keyVaultSecretStatus(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            pfxBlob = javaType.pfxBlob().map({ args0 -> args0 }).orElse(null),
            publicKeyHash = javaType.publicKeyHash(),
            selfLink = javaType.selfLink(),
            serverFarmId = javaType.serverFarmId().map({ args0 -> args0 }).orElse(null),
            siteName = javaType.siteName(),
            subjectName = javaType.subjectName(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
            valid = javaType.valid(),
        )
    }
}
