@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Container App.
 * @property configuration Non versioned Container App configuration properties.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property kubeEnvironmentId Resource ID of the Container App's KubeEnvironment.
 * @property latestRevisionFqdn Fully Qualified Domain Name of the latest revision of the Container App.
 * @property latestRevisionName Name of the latest revision of the Container App.
 * @property location Resource Location.
 * @property name Resource Name.
 * @property provisioningState Provisioning state of the Container App.
 * @property tags Resource tags.
 * @property template Container App versioned application definition.
 * @property type Resource type.
 */
public data class GetContainerAppResult(
    public val configuration: ConfigurationResponse? = null,
    public val id: String,
    public val kind: String? = null,
    public val kubeEnvironmentId: String? = null,
    public val latestRevisionFqdn: String,
    public val latestRevisionName: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val template: TemplateResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetContainerAppResult): GetContainerAppResult = GetContainerAppResult(
            configuration = javaType.configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            kubeEnvironmentId = javaType.kubeEnvironmentId().map({ args0 -> args0 }).orElse(null),
            latestRevisionFqdn = javaType.latestRevisionFqdn(),
            latestRevisionName = javaType.latestRevisionName(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            template = javaType.template().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.TemplateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
