@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Static Site Custom Domain Overview ARM resource.
 * @property createdOn The date and time on which the custom domain was created for the static site.
 * @property domainName The domain name for the static site custom domain.
 * @property errorMessage
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property status The status of the custom domain
 * @property type Resource type.
 * @property validationToken The TXT record validation token
 */
public data class GetStaticSiteCustomDomainResult(
    public val createdOn: String,
    public val domainName: String,
    public val errorMessage: String,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val status: String,
    public val type: String,
    public val validationToken: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetStaticSiteCustomDomainResult): GetStaticSiteCustomDomainResult = GetStaticSiteCustomDomainResult(
            createdOn = javaType.createdOn(),
            domainName = javaType.domainName(),
            errorMessage = javaType.errorMessage(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            status = javaType.status(),
            type = javaType.type(),
            validationToken = javaType.validationToken(),
        )
    }
}
