@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Static Site Database Connection resource.
 * @property configurationFiles A list of configuration files associated with this database connection.
 * @property connectionIdentity If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
 * @property connectionString The connection string to use to connect to the database.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property region The region of the database resource.
 * @property resourceId The resource id of the database.
 * @property type Resource type.
 */
public data class GetStaticSiteDatabaseConnectionResult(
    public val configurationFiles: List<StaticSiteDatabaseConnectionConfigurationFileOverviewResponse>,
    public val connectionIdentity: String? = null,
    public val connectionString: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val region: String,
    public val resourceId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetStaticSiteDatabaseConnectionResult): GetStaticSiteDatabaseConnectionResult = GetStaticSiteDatabaseConnectionResult(
            configurationFiles = javaType.configurationFiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.StaticSiteDatabaseConnectionConfigurationFileOverviewResponse.Companion.toKotlin(args0)
                })
            }),
            connectionIdentity = javaType.connectionIdentity().map({ args0 -> args0 }).orElse(null),
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            region = javaType.region(),
            resourceId = javaType.resourceId(),
            type = javaType.type(),
        )
    }
}
