@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Static Site ARM resource.
 * @property allowConfigFileUpdates <code>false</code> if config file is locked for this static web app; otherwise, <code>true</code>.
 * @property branch The target branch in the repository.
 * @property buildProperties Build properties to configure on the repository.
 * @property contentDistributionEndpoint The content distribution endpoint for the static site.
 * @property customDomains The custom domains associated with this static site.
 * @property databaseConnections Database connections for the static site
 * @property defaultHostname The default autogenerated hostname for the static site.
 * @property enterpriseGradeCdnStatus State indicating the status of the enterprise grade CDN serving traffic to the static web app.
 * @property id Resource Id.
 * @property identity Managed service identity.
 * @property keyVaultReferenceIdentity Identity to use for Key Vault Reference authentication.
 * @property kind Kind of resource.
 * @property linkedBackends Backends linked to the static side
 * @property location Resource Location.
 * @property name Resource Name.
 * @property privateEndpointConnections Private endpoint connections
 * @property provider The provider that submitted the last deployment to the primary environment of the static site.
 * @property publicNetworkAccess State indicating whether public traffic are allowed or not for a static web app. Allowed Values: 'Enabled', 'Disabled' or an empty string.
 * @property repositoryToken A user's github repository token. This is used to setup the Github Actions workflow file and API secrets.
 * @property repositoryUrl URL for the repository of the static site.
 * @property sku Description of a SKU for a scalable resource.
 * @property stagingEnvironmentPolicy State indicating whether staging environments are allowed or not allowed for a static web app.
 * @property tags Resource tags.
 * @property templateProperties Template options for generating a new repository.
 * @property type Resource type.
 * @property userProvidedFunctionApps User provided function apps registered with the static site
 */
public data class GetStaticSiteResult(
    public val allowConfigFileUpdates: Boolean? = null,
    public val branch: String? = null,
    public val buildProperties: StaticSiteBuildPropertiesResponse? = null,
    public val contentDistributionEndpoint: String,
    public val customDomains: List<String>,
    public val databaseConnections: List<DatabaseConnectionOverviewResponse>,
    public val defaultHostname: String,
    public val enterpriseGradeCdnStatus: String? = null,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val keyVaultReferenceIdentity: String,
    public val kind: String? = null,
    public val linkedBackends: List<StaticSiteLinkedBackendResponse>,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse>,
    public val provider: String? = null,
    public val publicNetworkAccess: String? = null,
    public val repositoryToken: String? = null,
    public val repositoryUrl: String? = null,
    public val sku: SkuDescriptionResponse? = null,
    public val stagingEnvironmentPolicy: String? = null,
    public val tags: Map<String, String>? = null,
    public val templateProperties: StaticSiteTemplateOptionsResponse? = null,
    public val type: String,
    public val userProvidedFunctionApps: List<StaticSiteUserProvidedFunctionAppResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetStaticSiteResult): GetStaticSiteResult = GetStaticSiteResult(
            allowConfigFileUpdates = javaType.allowConfigFileUpdates().map({ args0 -> args0 }).orElse(null),
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            buildProperties = javaType.buildProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.StaticSiteBuildPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contentDistributionEndpoint = javaType.contentDistributionEndpoint(),
            customDomains = javaType.customDomains().map({ args0 -> args0 }),
            databaseConnections = javaType.databaseConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.DatabaseConnectionOverviewResponse.Companion.toKotlin(args0)
                })
            }),
            defaultHostname = javaType.defaultHostname(),
            enterpriseGradeCdnStatus = javaType.enterpriseGradeCdnStatus().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyVaultReferenceIdentity = javaType.keyVaultReferenceIdentity(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            linkedBackends = javaType.linkedBackends().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.StaticSiteLinkedBackendResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provider = javaType.provider().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            repositoryToken = javaType.repositoryToken().map({ args0 -> args0 }).orElse(null),
            repositoryUrl = javaType.repositoryUrl().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.SkuDescriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            stagingEnvironmentPolicy = javaType.stagingEnvironmentPolicy().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateProperties = javaType.templateProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.StaticSiteTemplateOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            userProvidedFunctionApps = javaType.userProvidedFunctionApps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.StaticSiteUserProvidedFunctionAppResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
