@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * User credentials used for publishing activity.
 * @property active True if deployment is currently active, false if completed and null if not started.
 * @property author Who authored the deployment.
 * @property authorEmail Author email.
 * @property deployer Who performed the deployment.
 * @property details Details on deployment.
 * @property endTime End time.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property message Details about deployment status.
 * @property name Resource Name.
 * @property startTime Start time.
 * @property status Deployment status.
 * @property type Resource type.
 */
public data class GetWebAppDeploymentResult(
    public val active: Boolean? = null,
    public val author: String? = null,
    public val authorEmail: String? = null,
    public val deployer: String? = null,
    public val details: String? = null,
    public val endTime: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val message: String? = null,
    public val name: String,
    public val startTime: String? = null,
    public val status: Int? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppDeploymentResult): GetWebAppDeploymentResult = GetWebAppDeploymentResult(
            active = javaType.active().map({ args0 -> args0 }).orElse(null),
            author = javaType.author().map({ args0 -> args0 }).orElse(null),
            authorEmail = javaType.authorEmail().map({ args0 -> args0 }).orElse(null),
            deployer = javaType.deployer().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 -> args0 }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
