@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration of App Service site logs.
 * @property applicationLogs Application logs configuration.
 * @property detailedErrorMessages Detailed error messages configuration.
 * @property failedRequestsTracing Failed requests tracing configuration.
 * @property httpLogs HTTP logs configuration.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property type Resource type.
 */
public data class GetWebAppDiagnosticLogsConfigurationResult(
    public val applicationLogs: ApplicationLogsConfigResponse? = null,
    public val detailedErrorMessages: EnabledConfigResponse? = null,
    public val failedRequestsTracing: EnabledConfigResponse? = null,
    public val httpLogs: HttpLogsConfigResponse? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppDiagnosticLogsConfigurationResult): GetWebAppDiagnosticLogsConfigurationResult = GetWebAppDiagnosticLogsConfigurationResult(
            applicationLogs = javaType.applicationLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ApplicationLogsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            detailedErrorMessages = javaType.detailedErrorMessages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.EnabledConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            failedRequestsTracing = javaType.failedRequestsTracing().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.EnabledConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpLogs = javaType.httpLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.HttpLogsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
