@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Function information.
 * @property config Config information.
 * @property configHref Config URI.
 * @property files File list.
 * @property functionAppId Function App ID.
 * @property href Function URI.
 * @property id Resource Id.
 * @property invokeUrlTemplate The invocation URL
 * @property isDisabled Gets or sets a value indicating whether the function is disabled
 * @property kind Kind of resource.
 * @property language The function language
 * @property name Resource Name.
 * @property scriptHref Script URI.
 * @property scriptRootPathHref Script root path URI.
 * @property secretsFileHref Secrets file URI.
 * @property testData Test data used when testing via the Azure Portal.
 * @property testDataHref Test data URI.
 * @property type Resource type.
 */
public data class GetWebAppFunctionResult(
    public val config: Any? = null,
    public val configHref: String? = null,
    public val files: Map<String, String>? = null,
    public val functionAppId: String? = null,
    public val href: String? = null,
    public val id: String,
    public val invokeUrlTemplate: String? = null,
    public val isDisabled: Boolean? = null,
    public val kind: String? = null,
    public val language: String? = null,
    public val name: String,
    public val scriptHref: String? = null,
    public val scriptRootPathHref: String? = null,
    public val secretsFileHref: String? = null,
    public val testData: String? = null,
    public val testDataHref: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppFunctionResult): GetWebAppFunctionResult = GetWebAppFunctionResult(
            config = javaType.config().map({ args0 -> args0 }).orElse(null),
            configHref = javaType.configHref().map({ args0 -> args0 }).orElse(null),
            files = javaType.files().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            functionAppId = javaType.functionAppId().map({ args0 -> args0 }).orElse(null),
            href = javaType.href().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            invokeUrlTemplate = javaType.invokeUrlTemplate().map({ args0 -> args0 }).orElse(null),
            isDisabled = javaType.isDisabled().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            language = javaType.language().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            scriptHref = javaType.scriptHref().map({ args0 -> args0 }).orElse(null),
            scriptRootPathHref = javaType.scriptRootPathHref().map({ args0 -> args0 }).orElse(null),
            secretsFileHref = javaType.secretsFileHref().map({ args0 -> args0 }).orElse(null),
            testData = javaType.testData().map({ args0 -> args0 }).orElse(null),
            testDataHref = javaType.testDataHref().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
