@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A hostname binding object.
 * @property azureResourceName Azure resource name.
 * @property azureResourceType Azure resource type.
 * @property customHostNameDnsRecordType Custom DNS record type.
 * @property domainId Fully qualified ARM domain resource URI.
 * @property hostNameType Hostname type.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property siteName App Service app name.
 * @property sslState SSL type
 * @property thumbprint SSL certificate thumbprint
 * @property type Resource type.
 * @property virtualIP Virtual IP address assigned to the hostname if IP based SSL is enabled.
 */
public data class GetWebAppHostNameBindingSlotResult(
    public val azureResourceName: String? = null,
    public val azureResourceType: String? = null,
    public val customHostNameDnsRecordType: String? = null,
    public val domainId: String? = null,
    public val hostNameType: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val siteName: String? = null,
    public val sslState: String? = null,
    public val thumbprint: String? = null,
    public val type: String,
    public val virtualIP: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppHostNameBindingSlotResult): GetWebAppHostNameBindingSlotResult = GetWebAppHostNameBindingSlotResult(
            azureResourceName = javaType.azureResourceName().map({ args0 -> args0 }).orElse(null),
            azureResourceType = javaType.azureResourceType().map({ args0 -> args0 }).orElse(null),
            customHostNameDnsRecordType = javaType.customHostNameDnsRecordType().map({ args0 ->
                args0
            }).orElse(null),
            domainId = javaType.domainId().map({ args0 -> args0 }).orElse(null),
            hostNameType = javaType.hostNameType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            siteName = javaType.siteName().map({ args0 -> args0 }).orElse(null),
            sslState = javaType.sslState().map({ args0 -> args0 }).orElse(null),
            thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            virtualIP = javaType.virtualIP(),
        )
    }
}
