@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Hybrid Connection contract. This is used to configure a Hybrid Connection.
 * @property hostname The hostname of the endpoint.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property port The port of the endpoint.
 * @property relayArmUri The ARM URI to the Service Bus relay.
 * @property relayName The name of the Service Bus relay.
 * @property sendKeyName The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
 * @property sendKeyValue The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned
 * normally, use the POST /listKeys API instead.
 * @property serviceBusNamespace The name of the Service Bus namespace.
 * @property serviceBusSuffix The suffix for the service bus endpoint. By default this is .servicebus.windows.net
 * @property type Resource type.
 */
public data class GetWebAppHybridConnectionResult(
    public val hostname: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val port: Int? = null,
    public val relayArmUri: String? = null,
    public val relayName: String? = null,
    public val sendKeyName: String? = null,
    public val sendKeyValue: String? = null,
    public val serviceBusNamespace: String? = null,
    public val serviceBusSuffix: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppHybridConnectionResult): GetWebAppHybridConnectionResult = GetWebAppHybridConnectionResult(
            hostname = javaType.hostname().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            relayArmUri = javaType.relayArmUri().map({ args0 -> args0 }).orElse(null),
            relayName = javaType.relayName().map({ args0 -> args0 }).orElse(null),
            sendKeyName = javaType.sendKeyName().map({ args0 -> args0 }).orElse(null),
            sendKeyValue = javaType.sendKeyValue().map({ args0 -> args0 }).orElse(null),
            serviceBusNamespace = javaType.serviceBusNamespace().map({ args0 -> args0 }).orElse(null),
            serviceBusSuffix = javaType.serviceBusSuffix().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
