@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Remote Private Endpoint Connection ARM resource.
 * @property id Resource Id.
 * @property ipAddresses Private IPAddresses mapped to the remote private endpoint
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property privateEndpoint PrivateEndpoint of a remote private endpoint connection
 * @property privateLinkServiceConnectionState The state of a private link connection
 * @property provisioningState
 * @property type Resource type.
 */
public data class GetWebAppPrivateEndpointConnectionResult(
    public val id: String,
    public val ipAddresses: List<String>? = null,
    public val kind: String? = null,
    public val name: String,
    public val privateEndpoint: ArmIdWrapperResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkConnectionStateResponse? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppPrivateEndpointConnectionResult): GetWebAppPrivateEndpointConnectionResult = GetWebAppPrivateEndpointConnectionResult(
            id = javaType.id(),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ArmIdWrapperResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.PrivateLinkConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
