@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Public certificate object
 * @property blob Public Certificate byte array
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property publicCertificateLocation Public Certificate Location
 * @property thumbprint Certificate Thumbprint
 * @property type Resource type.
 */
public data class GetWebAppPublicCertificateResult(
    public val blob: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val publicCertificateLocation: String? = null,
    public val thumbprint: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppPublicCertificateResult): GetWebAppPublicCertificateResult = GetWebAppPublicCertificateResult(
            blob = javaType.blob().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            publicCertificateLocation = javaType.publicCertificateLocation().map({ args0 ->
                args0
            }).orElse(null),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
        )
    }
}
