@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Publishing Credentials Policies parameters.
 * @property allow <code>true</code> to allow access to a publishing method; otherwise, <code>false</code>.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property type Resource type.
 */
public data class GetWebAppScmAllowedResult(
    public val allow: Boolean,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppScmAllowedResult): GetWebAppScmAllowedResult = GetWebAppScmAllowedResult(
            allow = javaType.allow(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
