@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container of a site
 * @property authType Auth Type
 * @property createdTime Created Time
 * @property environmentVariables List of environment variables
 * @property id Resource Id.
 * @property image Image Name
 * @property isMain <code>true</code> if the container is the main site container; <code>false</code> otherwise.
 * @property kind Kind of resource.
 * @property lastModifiedTime Last Modified Time
 * @property name Resource Name.
 * @property passwordSecret Password Secret
 * @property startUpCommand StartUp Command
 * @property targetPort Target Port
 * @property type Resource type.
 * @property userManagedIdentityClientId UserManagedIdentity ClientId
 * @property userName User Name
 * @property volumeMounts List of volume mounts
 */
public data class GetWebAppSiteContainerSlotResult(
    public val authType: String? = null,
    public val createdTime: String,
    public val environmentVariables: List<EnvironmentVariableResponse>? = null,
    public val id: String,
    public val image: String,
    public val isMain: Boolean,
    public val kind: String? = null,
    public val lastModifiedTime: String,
    public val name: String,
    public val passwordSecret: String? = null,
    public val startUpCommand: String? = null,
    public val targetPort: String? = null,
    public val type: String,
    public val userManagedIdentityClientId: String? = null,
    public val userName: String? = null,
    public val volumeMounts: List<VolumeMountResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppSiteContainerSlotResult): GetWebAppSiteContainerSlotResult = GetWebAppSiteContainerSlotResult(
            authType = javaType.authType().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime(),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.EnvironmentVariableResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            image = javaType.image(),
            isMain = javaType.isMain(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            lastModifiedTime = javaType.lastModifiedTime(),
            name = javaType.name(),
            passwordSecret = javaType.passwordSecret().map({ args0 -> args0 }).orElse(null),
            startUpCommand = javaType.startUpCommand().map({ args0 -> args0 }).orElse(null),
            targetPort = javaType.targetPort().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userManagedIdentityClientId = javaType.userManagedIdentityClientId().map({ args0 ->
                args0
            }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
            volumeMounts = javaType.volumeMounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.VolumeMountResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
