@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Site Extension Information.
 * @property authors List of authors.
 * @property comment Site Extension comment.
 * @property description Detailed description.
 * @property downloadCount Count of downloads.
 * @property extensionId Site extension ID.
 * @property extensionType Site extension type.
 * @property extensionUrl Extension URL.
 * @property feedUrl Feed URL.
 * @property iconUrl Icon URL.
 * @property id Resource Id.
 * @property installedDateTime Installed timestamp.
 * @property installerCommandLineParams Installer command line parameters.
 * @property kind Kind of resource.
 * @property licenseUrl License URL.
 * @property localIsLatestVersion <code>true</code> if the local version is the latest version; <code>false</code> otherwise.
 * @property localPath Local path.
 * @property name Resource Name.
 * @property projectUrl Project URL.
 * @property provisioningState Provisioning state.
 * @property publishedDateTime Published timestamp.
 * @property summary Summary description.
 * @property title
 * @property type Resource type.
 * @property version Version information.
 */
public data class GetWebAppSiteExtensionSlotResult(
    public val authors: List<String>? = null,
    public val comment: String? = null,
    public val description: String? = null,
    public val downloadCount: Int? = null,
    public val extensionId: String? = null,
    public val extensionType: String? = null,
    public val extensionUrl: String? = null,
    public val feedUrl: String? = null,
    public val iconUrl: String? = null,
    public val id: String,
    public val installedDateTime: String? = null,
    public val installerCommandLineParams: String? = null,
    public val kind: String? = null,
    public val licenseUrl: String? = null,
    public val localIsLatestVersion: Boolean? = null,
    public val localPath: String? = null,
    public val name: String,
    public val projectUrl: String? = null,
    public val provisioningState: String? = null,
    public val publishedDateTime: String? = null,
    public val summary: String? = null,
    public val title: String? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GetWebAppSiteExtensionSlotResult): GetWebAppSiteExtensionSlotResult = GetWebAppSiteExtensionSlotResult(
            authors = javaType.authors().map({ args0 -> args0 }),
            comment = javaType.comment().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            downloadCount = javaType.downloadCount().map({ args0 -> args0 }).orElse(null),
            extensionId = javaType.extensionId().map({ args0 -> args0 }).orElse(null),
            extensionType = javaType.extensionType().map({ args0 -> args0 }).orElse(null),
            extensionUrl = javaType.extensionUrl().map({ args0 -> args0 }).orElse(null),
            feedUrl = javaType.feedUrl().map({ args0 -> args0 }).orElse(null),
            iconUrl = javaType.iconUrl().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            installedDateTime = javaType.installedDateTime().map({ args0 -> args0 }).orElse(null),
            installerCommandLineParams = javaType.installerCommandLineParams().map({ args0 ->
                args0
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            licenseUrl = javaType.licenseUrl().map({ args0 -> args0 }).orElse(null),
            localIsLatestVersion = javaType.localIsLatestVersion().map({ args0 -> args0 }).orElse(null),
            localPath = javaType.localPath().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            projectUrl = javaType.projectUrl().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            publishedDateTime = javaType.publishedDateTime().map({ args0 -> args0 }).orElse(null),
            summary = javaType.summary().map({ args0 -> args0 }).orElse(null),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
