@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The GitHub action configuration.
 * @property codeConfiguration GitHub Action code configuration.
 * @property containerConfiguration GitHub Action container configuration.
 * @property generateWorkflowFile Workflow option to determine whether the workflow file should be generated and written to the repository.
 * @property isLinux This will help determine the workflow configuration to select.
 */
public data class GitHubActionConfigurationResponse(
    public val codeConfiguration: GitHubActionCodeConfigurationResponse? = null,
    public val containerConfiguration: GitHubActionContainerConfigurationResponse? = null,
    public val generateWorkflowFile: Boolean? = null,
    public val isLinux: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GitHubActionConfigurationResponse): GitHubActionConfigurationResponse = GitHubActionConfigurationResponse(
            codeConfiguration = javaType.codeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.GitHubActionCodeConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerConfiguration = javaType.containerConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.GitHubActionContainerConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            generateWorkflowFile = javaType.generateWorkflowFile().map({ args0 -> args0 }).orElse(null),
            isLinux = javaType.isLinux().map({ args0 -> args0 }).orElse(null),
        )
    }
}
