@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The GitHub action container configuration.
 * @property imageName The image name for the build.
 * @property password The password used to upload the image to the container registry.
 * @property serverUrl The server URL for the container registry where the build will be hosted.
 * @property username The username used to upload the image to the container registry.
 */
public data class GitHubActionContainerConfigurationResponse(
    public val imageName: String? = null,
    public val password: String? = null,
    public val serverUrl: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.GitHubActionContainerConfigurationResponse): GitHubActionContainerConfigurationResponse = GitHubActionContainerConfigurationResponse(
            imageName = javaType.imageName().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            serverUrl = javaType.serverUrl().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
