@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * SSL-enabled hostname.
 * @property hostType Indicates whether the hostname is a standard or repository hostname.
 * @property name Hostname.
 * @property sslState SSL type.
 * @property thumbprint SSL certificate thumbprint.
 * @property toUpdate Set to <code>true</code> to update existing hostname.
 * @property virtualIP Virtual IP address assigned to the hostname if IP based SSL is enabled.
 */
public data class HostNameSslStateResponse(
    public val hostType: String? = null,
    public val name: String? = null,
    public val sslState: String? = null,
    public val thumbprint: String? = null,
    public val toUpdate: Boolean? = null,
    public val virtualIP: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.HostNameSslStateResponse): HostNameSslStateResponse = HostNameSslStateResponse(
            hostType = javaType.hostType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sslState = javaType.sslState().map({ args0 -> args0 }).orElse(null),
            thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
            toUpdate = javaType.toUpdate().map({ args0 -> args0 }).orElse(null),
            virtualIP = javaType.virtualIP().map({ args0 -> args0 }).orElse(null),
        )
    }
}
