@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A domain specific resource identifier.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property type Resource type.
 * @property value String representation of the identity.
 */
public data class IdentifierResponse(
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.IdentifierResponse): IdentifierResponse = IdentifierResponse(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
