@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container App Ingress configuration.
 * @property allowInsecure Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
 * @property external Bool indicating if app exposes an external http endpoint
 * @property fqdn Hostname.
 * @property targetPort Target Port in containers for traffic from ingress
 * @property traffic
 * @property transport Ingress transport protocol
 */
public data class IngressResponse(
    public val allowInsecure: Boolean? = null,
    public val `external`: Boolean? = null,
    public val fqdn: String,
    public val targetPort: Int? = null,
    public val traffic: List<TrafficWeightResponse>? = null,
    public val transport: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.IngressResponse): IngressResponse = IngressResponse(
            allowInsecure = javaType.allowInsecure().map({ args0 -> args0 }).orElse(null),
            `external` = javaType.`external`().map({ args0 -> args0 }).orElse(null),
            fqdn = javaType.fqdn(),
            targetPort = javaType.targetPort().map({ args0 -> args0 }).orElse(null),
            traffic = javaType.traffic().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.TrafficWeightResponse.Companion.toKotlin(args0)
                })
            }),
            transport = javaType.transport().map({ args0 -> args0 }).orElse(null),
        )
    }
}
