@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specification for a Kubernetes Environment to use for this resource.
 * @property id Resource ID of the Kubernetes Environment.
 * @property name Name of the Kubernetes Environment.
 * @property type Resource type of the Kubernetes Environment.
 */
public data class KubeEnvironmentProfileResponse(
    public val id: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.KubeEnvironmentProfileResponse): KubeEnvironmentProfileResponse = KubeEnvironmentProfileResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
