@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property connectionKey Connection Key
 * @property parameterValues Tokens/Claim
 */
public data class ListConnectionKeysResult(
    public val connectionKey: String? = null,
    public val parameterValues: Map<String, Any>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListConnectionKeysResult): ListConnectionKeysResult = ListConnectionKeysResult(
            connectionKey = javaType.connectionKey().map({ args0 -> args0 }).orElse(null),
            parameterValues = javaType.parameterValues().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
