@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Configuration settings for the Azure App Service Authentication / Authorization feature.
 * @property aadClaimsAuthorization Gets a JSON string containing the Azure AD Acl settings.
 * @property additionalLoginParams Login parameters to send to the OpenID Connect authorization endpoint when
 * a user logs in. Each parameter must be in the form "key=value".
 * @property allowedAudiences Allowed audience values to consider when validating JSON Web Tokens issued by
 * Azure Active Directory. Note that the <code>ClientID</code> value is always considered an
 * allowed audience, regardless of this setting.
 * @property allowedExternalRedirectUrls External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
 * This is an advanced setting typically only needed by Windows Store application backends.
 * Note that URLs within the current domain are always implicitly allowed.
 * @property authFilePath The path of the config file containing auth settings.
 * If the path is relative, base will the site's root directory.
 * @property clientId The Client ID of this relying party application, known as the client_id.
 * This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
 * other 3rd party OpenID Connect providers.
 * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
 * @property clientSecret The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
 * This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
 * Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
 * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
 * @property clientSecretCertificateThumbprint An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
 * a replacement for the Client Secret. It is also optional.
 * @property clientSecretSettingName The app setting name that contains the client secret of the relying party application.
 * @property configVersion The ConfigVersion of the Authentication / Authorization feature in use for the current app.
 * The setting in this value can control the behavior of the control plane for Authentication / Authorization.
 * @property defaultProvider The default authentication provider to use when multiple providers are configured.
 * This setting is only needed if multiple providers are configured and the unauthenticated client
 * action is set to "RedirectToLoginPage".
 * @property enabled <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
 * @property facebookAppId The App ID of the Facebook app used for login.
 * This setting is required for enabling Facebook Login.
 * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
 * @property facebookAppSecret The App Secret of the Facebook app used for Facebook Login.
 * This setting is required for enabling Facebook Login.
 * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
 * @property facebookAppSecretSettingName The app setting name that contains the app secret used for Facebook Login.
 * @property facebookOAuthScopes The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
 * This setting is optional.
 * Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
 * @property gitHubClientId The Client Id of the GitHub app used for login.
 * This setting is required for enabling Github login
 * @property gitHubClientSecret The Client Secret of the GitHub app used for Github Login.
 * This setting is required for enabling Github login.
 * @property gitHubClientSecretSettingName The app setting name that contains the client secret of the Github
 * app used for GitHub Login.
 * @property gitHubOAuthScopes The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
 * This setting is optional
 * @property googleClientId The OpenID Connect Client ID for the Google web application.
 * This setting is required for enabling Google Sign-In.
 * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
 * @property googleClientSecret The client secret associated with the Google web application.
 * This setting is required for enabling Google Sign-In.
 * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
 * @property googleClientSecretSettingName The app setting name that contains the client secret associated with
 * the Google web application.
 * @property googleOAuthScopes The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
 * This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
 * Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
 * @property id Resource Id.
 * @property isAuthFromFile "true" if the auth config settings should be read from a file,
 * "false" otherwise
 * @property issuer The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
 * When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
 * This URI is a case-sensitive identifier for the token issuer.
 * More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
 * @property kind Kind of resource.
 * @property microsoftAccountClientId The OAuth 2.0 client ID that was created for the app used for authentication.
 * This setting is required for enabling Microsoft Account authentication.
 * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
 * @property microsoftAccountClientSecret The OAuth 2.0 client secret that was created for the app used for authentication.
 * This setting is required for enabling Microsoft Account authentication.
 * Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
 * @property microsoftAccountClientSecretSettingName The app setting name containing the OAuth 2.0 client secret that was created for the
 * app used for authentication.
 * @property microsoftAccountOAuthScopes The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
 * This setting is optional. If not specified, "wl.basic" is used as the default scope.
 * Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
 * @property name Resource Name.
 * @property runtimeVersion The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
 * The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
 * @property tokenRefreshExtensionHours The number of hours after session token expiration that a session token can be used to
 * call the token refresh API. The default is 72 hours.
 * @property tokenStoreEnabled <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
 *  The default is <code>false</code>.
 * @property twitterConsumerKey The OAuth 1.0a consumer key of the Twitter application used for sign-in.
 * This setting is required for enabling Twitter Sign-In.
 * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
 * @property twitterConsumerSecret The OAuth 1.0a consumer secret of the Twitter application used for sign-in.
 * This setting is required for enabling Twitter Sign-In.
 * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
 * @property twitterConsumerSecretSettingName The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
 * application used for sign-in.
 * @property type Resource type.
 * @property unauthenticatedClientAction The action to take when an unauthenticated client attempts to access the app.
 * @property validateIssuer Gets a value indicating whether the issuer should be a valid HTTPS url and be validated as such.
 */
public data class ListWebAppAuthSettingsResult(
    public val aadClaimsAuthorization: String? = null,
    public val additionalLoginParams: List<String>? = null,
    public val allowedAudiences: List<String>? = null,
    public val allowedExternalRedirectUrls: List<String>? = null,
    public val authFilePath: String? = null,
    public val clientId: String? = null,
    public val clientSecret: String? = null,
    public val clientSecretCertificateThumbprint: String? = null,
    public val clientSecretSettingName: String? = null,
    public val configVersion: String? = null,
    public val defaultProvider: String? = null,
    public val enabled: Boolean? = null,
    public val facebookAppId: String? = null,
    public val facebookAppSecret: String? = null,
    public val facebookAppSecretSettingName: String? = null,
    public val facebookOAuthScopes: List<String>? = null,
    public val gitHubClientId: String? = null,
    public val gitHubClientSecret: String? = null,
    public val gitHubClientSecretSettingName: String? = null,
    public val gitHubOAuthScopes: List<String>? = null,
    public val googleClientId: String? = null,
    public val googleClientSecret: String? = null,
    public val googleClientSecretSettingName: String? = null,
    public val googleOAuthScopes: List<String>? = null,
    public val id: String,
    public val isAuthFromFile: String? = null,
    public val issuer: String? = null,
    public val kind: String? = null,
    public val microsoftAccountClientId: String? = null,
    public val microsoftAccountClientSecret: String? = null,
    public val microsoftAccountClientSecretSettingName: String? = null,
    public val microsoftAccountOAuthScopes: List<String>? = null,
    public val name: String,
    public val runtimeVersion: String? = null,
    public val tokenRefreshExtensionHours: Double? = null,
    public val tokenStoreEnabled: Boolean? = null,
    public val twitterConsumerKey: String? = null,
    public val twitterConsumerSecret: String? = null,
    public val twitterConsumerSecretSettingName: String? = null,
    public val type: String,
    public val unauthenticatedClientAction: String? = null,
    public val validateIssuer: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListWebAppAuthSettingsResult): ListWebAppAuthSettingsResult = ListWebAppAuthSettingsResult(
            aadClaimsAuthorization = javaType.aadClaimsAuthorization().map({ args0 -> args0 }).orElse(null),
            additionalLoginParams = javaType.additionalLoginParams().map({ args0 -> args0 }),
            allowedAudiences = javaType.allowedAudiences().map({ args0 -> args0 }),
            allowedExternalRedirectUrls = javaType.allowedExternalRedirectUrls().map({ args0 -> args0 }),
            authFilePath = javaType.authFilePath().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            clientSecretCertificateThumbprint = javaType.clientSecretCertificateThumbprint().map({ args0 ->
                args0
            }).orElse(null),
            clientSecretSettingName = javaType.clientSecretSettingName().map({ args0 -> args0 }).orElse(null),
            configVersion = javaType.configVersion().map({ args0 -> args0 }).orElse(null),
            defaultProvider = javaType.defaultProvider().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            facebookAppId = javaType.facebookAppId().map({ args0 -> args0 }).orElse(null),
            facebookAppSecret = javaType.facebookAppSecret().map({ args0 -> args0 }).orElse(null),
            facebookAppSecretSettingName = javaType.facebookAppSecretSettingName().map({ args0 ->
                args0
            }).orElse(null),
            facebookOAuthScopes = javaType.facebookOAuthScopes().map({ args0 -> args0 }),
            gitHubClientId = javaType.gitHubClientId().map({ args0 -> args0 }).orElse(null),
            gitHubClientSecret = javaType.gitHubClientSecret().map({ args0 -> args0 }).orElse(null),
            gitHubClientSecretSettingName = javaType.gitHubClientSecretSettingName().map({ args0 ->
                args0
            }).orElse(null),
            gitHubOAuthScopes = javaType.gitHubOAuthScopes().map({ args0 -> args0 }),
            googleClientId = javaType.googleClientId().map({ args0 -> args0 }).orElse(null),
            googleClientSecret = javaType.googleClientSecret().map({ args0 -> args0 }).orElse(null),
            googleClientSecretSettingName = javaType.googleClientSecretSettingName().map({ args0 ->
                args0
            }).orElse(null),
            googleOAuthScopes = javaType.googleOAuthScopes().map({ args0 -> args0 }),
            id = javaType.id(),
            isAuthFromFile = javaType.isAuthFromFile().map({ args0 -> args0 }).orElse(null),
            issuer = javaType.issuer().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            microsoftAccountClientId = javaType.microsoftAccountClientId().map({ args0 -> args0 }).orElse(null),
            microsoftAccountClientSecret = javaType.microsoftAccountClientSecret().map({ args0 ->
                args0
            }).orElse(null),
            microsoftAccountClientSecretSettingName = javaType.microsoftAccountClientSecretSettingName().map({ args0 ->
                args0
            }).orElse(null),
            microsoftAccountOAuthScopes = javaType.microsoftAccountOAuthScopes().map({ args0 -> args0 }),
            name = javaType.name(),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
            tokenRefreshExtensionHours = javaType.tokenRefreshExtensionHours().map({ args0 ->
                args0
            }).orElse(null),
            tokenStoreEnabled = javaType.tokenStoreEnabled().map({ args0 -> args0 }).orElse(null),
            twitterConsumerKey = javaType.twitterConsumerKey().map({ args0 -> args0 }).orElse(null),
            twitterConsumerSecret = javaType.twitterConsumerSecret().map({ args0 -> args0 }).orElse(null),
            twitterConsumerSecretSettingName = javaType.twitterConsumerSecretSettingName().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
            unauthenticatedClientAction = javaType.unauthenticatedClientAction().map({ args0 ->
                args0
            }).orElse(null),
            validateIssuer = javaType.validateIssuer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
