@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Description of a backup which will be performed.
 * @property backupName Name of the backup.
 * @property backupSchedule Schedule for the backup if it is executed periodically.
 * @property databases Databases included in the backup.
 * @property enabled True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property storageAccountUrl SAS URL to the container.
 * @property type Resource type.
 */
public data class ListWebAppBackupConfigurationSlotResult(
    public val backupName: String? = null,
    public val backupSchedule: BackupScheduleResponse? = null,
    public val databases: List<DatabaseBackupSettingResponse>? = null,
    public val enabled: Boolean? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val storageAccountUrl: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListWebAppBackupConfigurationSlotResult): ListWebAppBackupConfigurationSlotResult = ListWebAppBackupConfigurationSlotResult(
            backupName = javaType.backupName().map({ args0 -> args0 }).orElse(null),
            backupSchedule = javaType.backupSchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.BackupScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databases = javaType.databases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.DatabaseBackupSettingResponse.Companion.toKotlin(args0)
                })
            }),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            storageAccountUrl = javaType.storageAccountUrl(),
            type = javaType.type(),
        )
    }
}
