@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Workflow properties definition.
 * @property id The resource id.
 * @property kind The resource kind.
 * @property location The resource location.
 * @property name Gets the resource name.
 * @property properties Additional workflow properties.
 * @property type Gets the resource type.
 */
public data class ListWebAppWorkflowsConnectionsSlotResult(
    public val id: String,
    public val kind: String? = null,
    public val location: String? = null,
    public val name: String,
    public val properties: WorkflowEnvelopeResponseProperties,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListWebAppWorkflowsConnectionsSlotResult): ListWebAppWorkflowsConnectionsSlotResult = ListWebAppWorkflowsConnectionsSlotResult(
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.web.kotlin.outputs.WorkflowEnvelopeResponseProperties.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
