@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration settings of the login flow, including the scopes that should be requested.
 * @property scopes A list of the scopes that should be requested while authenticating.
 */
public data class LoginScopesResponse(
    public val scopes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.LoginScopesResponse): LoginScopesResponse = LoginScopesResponse(
            scopes = javaType.scopes().map({ args0 -> args0 }),
        )
    }
}
