@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Configuration of an App Service app.
 * @property acrUseManagedIdentityCreds Flag to use Managed Identity Creds for ACR pull
 * @property acrUserManagedIdentityID If using user managed identity, the user managed identity ClientId
 * @property alwaysOn <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
 * @property apiDefinition Information about the formal API definition for the app.
 * @property apiManagementConfig Azure API management settings linked to the app.
 * @property appCommandLine App command line to launch.
 * @property appSettings Application settings.
 * @property autoHealEnabled <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
 * @property autoHealRules Auto Heal rules.
 * @property autoSwapSlotName Auto-swap slot name.
 * @property azureStorageAccounts List of Azure Storage Accounts.
 * @property connectionStrings Connection strings.
 * @property cors Cross-Origin Resource Sharing (CORS) settings.
 * @property defaultDocuments Default documents.
 * @property detailedErrorLoggingEnabled <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
 * @property documentRoot Document root.
 * @property elasticWebAppScaleLimit Maximum number of workers that a site can scale out to.
 * This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
 * @property experiments This is work around for polymorphic types.
 * @property ftpsState State of FTP / FTPS service
 * @property functionAppScaleLimit Maximum number of workers that a site can scale out to.
 * This setting only applies to the Consumption and Elastic Premium Plans
 * @property functionsRuntimeScaleMonitoringEnabled Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
 * the ScaleController will not monitor event sources directly, but will instead call to the
 * runtime to get scale status.
 * @property handlerMappings Handler mappings.
 * @property healthCheckPath Health check path
 * @property http20Enabled Http20Enabled: configures a web site to allow clients to connect over http2.0
 * @property httpLoggingEnabled <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
 * @property ipSecurityRestrictions IP security restrictions for main.
 * @property ipSecurityRestrictionsDefaultAction Default action for main access restriction if no rules are matched.
 * @property javaContainer Java container.
 * @property javaContainerVersion Java container version.
 * @property javaVersion Java version.
 * @property keyVaultReferenceIdentity Identity to use for Key Vault Reference authentication.
 * @property limits Site limits.
 * @property linuxFxVersion Linux App Framework and version
 * @property loadBalancing Site load balancing.
 * @property localMySqlEnabled <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
 * @property logsDirectorySizeLimit HTTP logs directory size limit.
 * @property machineKey Site MachineKey.
 * @property managedPipelineMode Managed pipeline mode.
 * @property managedServiceIdentityId Managed Service Identity Id
 * @property minTlsVersion MinTlsVersion: configures the minimum version of TLS required for SSL requests
 * @property minimumElasticInstanceCount Number of minimum instance count for a site
 * This setting only applies to the Elastic Plans
 * @property netFrameworkVersion .NET Framework version.
 * @property nodeVersion Version of Node.js.
 * @property numberOfWorkers Number of workers.
 * @property phpVersion Version of PHP.
 * @property powerShellVersion Version of PowerShell.
 * @property preWarmedInstanceCount Number of preWarmed instances.
 * This setting only applies to the Consumption and Elastic Plans
 * @property publicNetworkAccess Property to allow or block all public traffic.
 * @property publishingUsername Publishing user name.
 * @property push Push endpoint settings.
 * @property pythonVersion Version of Python.
 * @property remoteDebuggingEnabled <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
 * @property remoteDebuggingVersion Remote debugging version.
 * @property requestTracingEnabled <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
 * @property requestTracingExpirationTime Request tracing expiration time.
 * @property scmIpSecurityRestrictions IP security restrictions for scm.
 * @property scmIpSecurityRestrictionsDefaultAction Default action for scm access restriction if no rules are matched.
 * @property scmIpSecurityRestrictionsUseMain IP security restrictions for scm to use main.
 * @property scmMinTlsVersion ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
 * @property scmType SCM type.
 * @property tracingOptions Tracing options.
 * @property use32BitWorkerProcess <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
 * @property virtualApplications Virtual applications.
 * @property vnetName Virtual Network name.
 * @property vnetPrivatePortsCount The number of private ports assigned to this app. These will be assigned dynamically on runtime.
 * @property vnetRouteAllEnabled Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
 * @property webSocketsEnabled <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
 * @property websiteTimeZone Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
 * @property windowsFxVersion Xenon App Framework and version
 * @property xManagedServiceIdentityId Explicit Managed Service Identity Id
 */
public data class SiteConfigResponse(
    public val acrUseManagedIdentityCreds: Boolean? = null,
    public val acrUserManagedIdentityID: String? = null,
    public val alwaysOn: Boolean? = null,
    public val apiDefinition: ApiDefinitionInfoResponse? = null,
    public val apiManagementConfig: ApiManagementConfigResponse? = null,
    public val appCommandLine: String? = null,
    public val appSettings: List<NameValuePairResponse>? = null,
    public val autoHealEnabled: Boolean? = null,
    public val autoHealRules: AutoHealRulesResponse? = null,
    public val autoSwapSlotName: String? = null,
    public val azureStorageAccounts: Map<String, AzureStorageInfoValueResponse>? = null,
    public val connectionStrings: List<ConnStringInfoResponse>? = null,
    public val cors: CorsSettingsResponse? = null,
    public val defaultDocuments: List<String>? = null,
    public val detailedErrorLoggingEnabled: Boolean? = null,
    public val documentRoot: String? = null,
    public val elasticWebAppScaleLimit: Int? = null,
    public val experiments: ExperimentsResponse? = null,
    public val ftpsState: String? = null,
    public val functionAppScaleLimit: Int? = null,
    public val functionsRuntimeScaleMonitoringEnabled: Boolean? = null,
    public val handlerMappings: List<HandlerMappingResponse>? = null,
    public val healthCheckPath: String? = null,
    public val http20Enabled: Boolean? = null,
    public val httpLoggingEnabled: Boolean? = null,
    public val ipSecurityRestrictions: List<IpSecurityRestrictionResponse>? = null,
    public val ipSecurityRestrictionsDefaultAction: String? = null,
    public val javaContainer: String? = null,
    public val javaContainerVersion: String? = null,
    public val javaVersion: String? = null,
    public val keyVaultReferenceIdentity: String? = null,
    public val limits: SiteLimitsResponse? = null,
    public val linuxFxVersion: String? = null,
    public val loadBalancing: String? = null,
    public val localMySqlEnabled: Boolean? = null,
    public val logsDirectorySizeLimit: Int? = null,
    public val machineKey: SiteMachineKeyResponse,
    public val managedPipelineMode: String? = null,
    public val managedServiceIdentityId: Int? = null,
    public val minTlsVersion: String? = null,
    public val minimumElasticInstanceCount: Int? = null,
    public val netFrameworkVersion: String? = null,
    public val nodeVersion: String? = null,
    public val numberOfWorkers: Int? = null,
    public val phpVersion: String? = null,
    public val powerShellVersion: String? = null,
    public val preWarmedInstanceCount: Int? = null,
    public val publicNetworkAccess: String? = null,
    public val publishingUsername: String? = null,
    public val push: PushSettingsResponse? = null,
    public val pythonVersion: String? = null,
    public val remoteDebuggingEnabled: Boolean? = null,
    public val remoteDebuggingVersion: String? = null,
    public val requestTracingEnabled: Boolean? = null,
    public val requestTracingExpirationTime: String? = null,
    public val scmIpSecurityRestrictions: List<IpSecurityRestrictionResponse>? = null,
    public val scmIpSecurityRestrictionsDefaultAction: String? = null,
    public val scmIpSecurityRestrictionsUseMain: Boolean? = null,
    public val scmMinTlsVersion: String? = null,
    public val scmType: String? = null,
    public val tracingOptions: String? = null,
    public val use32BitWorkerProcess: Boolean? = null,
    public val virtualApplications: List<VirtualApplicationResponse>? = null,
    public val vnetName: String? = null,
    public val vnetPrivatePortsCount: Int? = null,
    public val vnetRouteAllEnabled: Boolean? = null,
    public val webSocketsEnabled: Boolean? = null,
    public val websiteTimeZone: String? = null,
    public val windowsFxVersion: String? = null,
    public val xManagedServiceIdentityId: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.SiteConfigResponse): SiteConfigResponse = SiteConfigResponse(
            acrUseManagedIdentityCreds = javaType.acrUseManagedIdentityCreds().map({ args0 ->
                args0
            }).orElse(null),
            acrUserManagedIdentityID = javaType.acrUserManagedIdentityID().map({ args0 -> args0 }).orElse(null),
            alwaysOn = javaType.alwaysOn().map({ args0 -> args0 }).orElse(null),
            apiDefinition = javaType.apiDefinition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ApiDefinitionInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            apiManagementConfig = javaType.apiManagementConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ApiManagementConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            appCommandLine = javaType.appCommandLine().map({ args0 -> args0 }).orElse(null),
            appSettings = javaType.appSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.NameValuePairResponse.Companion.toKotlin(args0)
                })
            }),
            autoHealEnabled = javaType.autoHealEnabled().map({ args0 -> args0 }).orElse(null),
            autoHealRules = javaType.autoHealRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.AutoHealRulesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoSwapSlotName = javaType.autoSwapSlotName().map({ args0 -> args0 }).orElse(null),
            azureStorageAccounts = javaType.azureStorageAccounts().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.web.kotlin.outputs.AzureStorageInfoValueResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            connectionStrings = javaType.connectionStrings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ConnStringInfoResponse.Companion.toKotlin(args0)
                })
            }),
            cors = javaType.cors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.CorsSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultDocuments = javaType.defaultDocuments().map({ args0 -> args0 }),
            detailedErrorLoggingEnabled = javaType.detailedErrorLoggingEnabled().map({ args0 ->
                args0
            }).orElse(null),
            documentRoot = javaType.documentRoot().map({ args0 -> args0 }).orElse(null),
            elasticWebAppScaleLimit = javaType.elasticWebAppScaleLimit().map({ args0 -> args0 }).orElse(null),
            experiments = javaType.experiments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ExperimentsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ftpsState = javaType.ftpsState().map({ args0 -> args0 }).orElse(null),
            functionAppScaleLimit = javaType.functionAppScaleLimit().map({ args0 -> args0 }).orElse(null),
            functionsRuntimeScaleMonitoringEnabled = javaType.functionsRuntimeScaleMonitoringEnabled().map({ args0 ->
                args0
            }).orElse(null),
            handlerMappings = javaType.handlerMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.HandlerMappingResponse.Companion.toKotlin(args0)
                })
            }),
            healthCheckPath = javaType.healthCheckPath().map({ args0 -> args0 }).orElse(null),
            http20Enabled = javaType.http20Enabled().map({ args0 -> args0 }).orElse(null),
            httpLoggingEnabled = javaType.httpLoggingEnabled().map({ args0 -> args0 }).orElse(null),
            ipSecurityRestrictions = javaType.ipSecurityRestrictions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.IpSecurityRestrictionResponse.Companion.toKotlin(args0)
                })
            }),
            ipSecurityRestrictionsDefaultAction = javaType.ipSecurityRestrictionsDefaultAction().map({ args0 ->
                args0
            }).orElse(null),
            javaContainer = javaType.javaContainer().map({ args0 -> args0 }).orElse(null),
            javaContainerVersion = javaType.javaContainerVersion().map({ args0 -> args0 }).orElse(null),
            javaVersion = javaType.javaVersion().map({ args0 -> args0 }).orElse(null),
            keyVaultReferenceIdentity = javaType.keyVaultReferenceIdentity().map({ args0 ->
                args0
            }).orElse(null),
            limits = javaType.limits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.SiteLimitsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linuxFxVersion = javaType.linuxFxVersion().map({ args0 -> args0 }).orElse(null),
            loadBalancing = javaType.loadBalancing().map({ args0 -> args0 }).orElse(null),
            localMySqlEnabled = javaType.localMySqlEnabled().map({ args0 -> args0 }).orElse(null),
            logsDirectorySizeLimit = javaType.logsDirectorySizeLimit().map({ args0 -> args0 }).orElse(null),
            machineKey = javaType.machineKey().let({ args0 ->
                com.pulumi.azurenative.web.kotlin.outputs.SiteMachineKeyResponse.Companion.toKotlin(args0)
            }),
            managedPipelineMode = javaType.managedPipelineMode().map({ args0 -> args0 }).orElse(null),
            managedServiceIdentityId = javaType.managedServiceIdentityId().map({ args0 -> args0 }).orElse(null),
            minTlsVersion = javaType.minTlsVersion().map({ args0 -> args0 }).orElse(null),
            minimumElasticInstanceCount = javaType.minimumElasticInstanceCount().map({ args0 ->
                args0
            }).orElse(null),
            netFrameworkVersion = javaType.netFrameworkVersion().map({ args0 -> args0 }).orElse(null),
            nodeVersion = javaType.nodeVersion().map({ args0 -> args0 }).orElse(null),
            numberOfWorkers = javaType.numberOfWorkers().map({ args0 -> args0 }).orElse(null),
            phpVersion = javaType.phpVersion().map({ args0 -> args0 }).orElse(null),
            powerShellVersion = javaType.powerShellVersion().map({ args0 -> args0 }).orElse(null),
            preWarmedInstanceCount = javaType.preWarmedInstanceCount().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            publishingUsername = javaType.publishingUsername().map({ args0 -> args0 }).orElse(null),
            push = javaType.push().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.PushSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            pythonVersion = javaType.pythonVersion().map({ args0 -> args0 }).orElse(null),
            remoteDebuggingEnabled = javaType.remoteDebuggingEnabled().map({ args0 -> args0 }).orElse(null),
            remoteDebuggingVersion = javaType.remoteDebuggingVersion().map({ args0 -> args0 }).orElse(null),
            requestTracingEnabled = javaType.requestTracingEnabled().map({ args0 -> args0 }).orElse(null),
            requestTracingExpirationTime = javaType.requestTracingExpirationTime().map({ args0 ->
                args0
            }).orElse(null),
            scmIpSecurityRestrictions = javaType.scmIpSecurityRestrictions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.IpSecurityRestrictionResponse.Companion.toKotlin(args0)
                })
            }),
            scmIpSecurityRestrictionsDefaultAction = javaType.scmIpSecurityRestrictionsDefaultAction().map({ args0 ->
                args0
            }).orElse(null),
            scmIpSecurityRestrictionsUseMain = javaType.scmIpSecurityRestrictionsUseMain().map({ args0 ->
                args0
            }).orElse(null),
            scmMinTlsVersion = javaType.scmMinTlsVersion().map({ args0 -> args0 }).orElse(null),
            scmType = javaType.scmType().map({ args0 -> args0 }).orElse(null),
            tracingOptions = javaType.tracingOptions().map({ args0 -> args0 }).orElse(null),
            use32BitWorkerProcess = javaType.use32BitWorkerProcess().map({ args0 -> args0 }).orElse(null),
            virtualApplications = javaType.virtualApplications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.VirtualApplicationResponse.Companion.toKotlin(args0)
                })
            }),
            vnetName = javaType.vnetName().map({ args0 -> args0 }).orElse(null),
            vnetPrivatePortsCount = javaType.vnetPrivatePortsCount().map({ args0 -> args0 }).orElse(null),
            vnetRouteAllEnabled = javaType.vnetRouteAllEnabled().map({ args0 -> args0 }).orElse(null),
            webSocketsEnabled = javaType.webSocketsEnabled().map({ args0 -> args0 }).orElse(null),
            websiteTimeZone = javaType.websiteTimeZone().map({ args0 -> args0 }).orElse(null),
            windowsFxVersion = javaType.windowsFxVersion().map({ args0 -> args0 }).orElse(null),
            xManagedServiceIdentityId = javaType.xManagedServiceIdentityId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
