@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * MachineKey of an app.
 * @property decryption Algorithm used for decryption.
 * @property decryptionKey Decryption key.
 * @property validation MachineKey validation.
 * @property validationKey Validation key.
 */
public data class SiteMachineKeyResponse(
    public val decryption: String? = null,
    public val decryptionKey: String? = null,
    public val validation: String? = null,
    public val validationKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.SiteMachineKeyResponse): SiteMachineKeyResponse = SiteMachineKeyResponse(
            decryption = javaType.decryption().map({ args0 -> args0 }).orElse(null),
            decryptionKey = javaType.decryptionKey().map({ args0 -> args0 }).orElse(null),
            validation = javaType.validation().map({ args0 -> args0 }).orElse(null),
            validationKey = javaType.validationKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
