@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Description of a SKU for a scalable resource.
 * @property capabilities Capabilities of the SKU, e.g., is traffic manager enabled?
 * @property capacity Current number of instances assigned to the resource.
 * @property family Family code of the resource SKU.
 * @property locations Locations of the SKU.
 * @property name Name of the resource SKU.
 * @property size Size specifier of the resource SKU.
 * @property skuCapacity Min, max, and default scale values of the SKU.
 * @property tier Service tier of the resource SKU.
 */
public data class SkuDescriptionResponse(
    public val capabilities: List<CapabilityResponse>? = null,
    public val capacity: Int? = null,
    public val family: String? = null,
    public val locations: List<String>? = null,
    public val name: String? = null,
    public val size: String? = null,
    public val skuCapacity: SkuCapacityResponse? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.SkuDescriptionResponse): SkuDescriptionResponse = SkuDescriptionResponse(
            capabilities = javaType.capabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.CapabilityResponse.Companion.toKotlin(args0)
                })
            }),
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            locations = javaType.locations().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            skuCapacity = javaType.skuCapacity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.SkuCapacityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
