@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Trigger based on request execution time.
 * @property count Request Count.
 * @property path Request Path.
 * @property timeInterval Time interval.
 * @property timeTaken Time taken.
 */
public data class SlowRequestsBasedTriggerResponse(
    public val count: Int? = null,
    public val path: String? = null,
    public val timeInterval: String? = null,
    public val timeTaken: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.SlowRequestsBasedTriggerResponse): SlowRequestsBasedTriggerResponse = SlowRequestsBasedTriggerResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            timeInterval = javaType.timeInterval().map({ args0 -> args0 }).orElse(null),
            timeTaken = javaType.timeTaken().map({ args0 -> args0 }).orElse(null),
        )
    }
}
