@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Build properties for the static site.
 * @property apiBuildCommand A custom command to run during deployment of the Azure Functions API application.
 * @property apiLocation The path to the api code within the repository.
 * @property appArtifactLocation Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
 * @property appBuildCommand A custom command to run during deployment of the static content application.
 * @property appLocation The path to the app code within the repository.
 * @property githubActionSecretNameOverride Github Action secret name override.
 * @property outputLocation The output path of the app after building.
 * @property skipGithubActionWorkflowGeneration Skip Github Action workflow generation.
 */
public data class StaticSiteBuildPropertiesResponse(
    public val apiBuildCommand: String? = null,
    public val apiLocation: String? = null,
    public val appArtifactLocation: String? = null,
    public val appBuildCommand: String? = null,
    public val appLocation: String? = null,
    public val githubActionSecretNameOverride: String? = null,
    public val outputLocation: String? = null,
    public val skipGithubActionWorkflowGeneration: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.StaticSiteBuildPropertiesResponse): StaticSiteBuildPropertiesResponse = StaticSiteBuildPropertiesResponse(
            apiBuildCommand = javaType.apiBuildCommand().map({ args0 -> args0 }).orElse(null),
            apiLocation = javaType.apiLocation().map({ args0 -> args0 }).orElse(null),
            appArtifactLocation = javaType.appArtifactLocation().map({ args0 -> args0 }).orElse(null),
            appBuildCommand = javaType.appBuildCommand().map({ args0 -> args0 }).orElse(null),
            appLocation = javaType.appLocation().map({ args0 -> args0 }).orElse(null),
            githubActionSecretNameOverride = javaType.githubActionSecretNameOverride().map({ args0 ->
                args0
            }).orElse(null),
            outputLocation = javaType.outputLocation().map({ args0 -> args0 }).orElse(null),
            skipGithubActionWorkflowGeneration = javaType.skipGithubActionWorkflowGeneration().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
