@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Static Site Linked Backend ARM resource.
 * @property backendResourceId The resource id of the backend linked to the static site
 * @property createdOn The date and time on which the backend was linked to the static site.
 * @property provisioningState The provisioning state of the linking process.
 * @property region The region of the backend linked to the static site
 */
public data class StaticSiteLinkedBackendResponse(
    public val backendResourceId: String? = null,
    public val createdOn: String,
    public val provisioningState: String,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.StaticSiteLinkedBackendResponse): StaticSiteLinkedBackendResponse = StaticSiteLinkedBackendResponse(
            backendResourceId = javaType.backendResourceId().map({ args0 -> args0 }).orElse(null),
            createdOn = javaType.createdOn(),
            provisioningState = javaType.provisioningState(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
