@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Container App versioned application definition.
 * Defines the desired state of an immutable revision.
 * Any changes to this section Will result in a new revision being created
 * @property containers List of container definitions for the Container App.
 * @property dapr Dapr configuration for the Container App.
 * @property revisionSuffix User friendly suffix that is appended to the revision name
 * @property scale Scaling properties for the Container App.
 */
public data class TemplateResponse(
    public val containers: List<ContainerResponse>? = null,
    public val dapr: DaprResponse? = null,
    public val revisionSuffix: String? = null,
    public val scale: ScaleResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.TemplateResponse): TemplateResponse = TemplateResponse(
            containers = javaType.containers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ContainerResponse.Companion.toKotlin(args0)
                })
            }),
            dapr = javaType.dapr().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.DaprResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            revisionSuffix = javaType.revisionSuffix().map({ args0 -> args0 }).orElse(null),
            scale = javaType.scale().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.ScaleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
