@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the app registration for the Twitter provider.
 * @property consumerKey The OAuth 1.0a consumer key of the Twitter application used for sign-in.
 * This setting is required for enabling Twitter Sign-In.
 * Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
 * @property consumerSecretSettingName The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
 * application used for sign-in.
 */
public data class TwitterRegistrationResponse(
    public val consumerKey: String? = null,
    public val consumerSecretSettingName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.TwitterRegistrationResponse): TwitterRegistrationResponse = TwitterRegistrationResponse(
            consumerKey = javaType.consumerKey().map({ args0 -> args0 }).orElse(null),
            consumerSecretSettingName = javaType.consumerSecretSettingName().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
