@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User Assigned identity.
 * @property clientId Client Id of user assigned identity
 * @property principalId Principal Id of user assigned identity
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.UserAssignedIdentityResponse): UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
