@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Virtual application in an app.
 * @property physicalPath Physical path.
 * @property preloadEnabled <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
 * @property virtualDirectories Virtual directories for virtual application.
 * @property virtualPath Virtual path.
 */
public data class VirtualApplicationResponse(
    public val physicalPath: String? = null,
    public val preloadEnabled: Boolean? = null,
    public val virtualDirectories: List<VirtualDirectoryResponse>? = null,
    public val virtualPath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.VirtualApplicationResponse): VirtualApplicationResponse = VirtualApplicationResponse(
            physicalPath = javaType.physicalPath().map({ args0 -> args0 }).orElse(null),
            preloadEnabled = javaType.preloadEnabled().map({ args0 -> args0 }).orElse(null),
            virtualDirectories = javaType.virtualDirectories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.VirtualDirectoryResponse.Companion.toKotlin(args0)
                })
            }),
            virtualPath = javaType.virtualPath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
