@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Directory for virtual application.
 * @property physicalPath Physical path.
 * @property virtualPath Path to virtual application.
 */
public data class VirtualDirectoryResponse(
    public val physicalPath: String? = null,
    public val virtualPath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.VirtualDirectoryResponse): VirtualDirectoryResponse = VirtualDirectoryResponse(
            physicalPath = javaType.physicalPath().map({ args0 -> args0 }).orElse(null),
            virtualPath = javaType.virtualPath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
