@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Virtual Network route contract used to pass routing information for a Virtual Network.
 * @property endAddress The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property name Resource Name.
 * @property routeType The type of route this is:
 * DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
 * INHERITED - Routes inherited from the real Virtual Network routes
 * STATIC - Static route set on the app only
 * These values will be used for syncing an app's routes with those from a Virtual Network.
 * @property startAddress The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
 * @property type Resource type.
 */
public data class VnetRouteResponse(
    public val endAddress: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val name: String,
    public val routeType: String? = null,
    public val startAddress: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.VnetRouteResponse): VnetRouteResponse = VnetRouteResponse(
            endAddress = javaType.endAddress().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            routeType = javaType.routeType().map({ args0 -> args0 }).orElse(null),
            startAddress = javaType.startAddress().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
