@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containerMountPath Target path on the container where volume is mounted on
 * @property data Config Data to be mounted on the volume
 * @property readOnly Boolean to specify if the mount is read only on the container
 * @property volumeSubPath Sub path in the volume where volume is mounted from.
 */
public data class VolumeMountResponse(
    public val containerMountPath: String,
    public val `data`: String? = null,
    public val readOnly: Boolean? = null,
    public val volumeSubPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.VolumeMountResponse): VolumeMountResponse = VolumeMountResponse(
            containerMountPath = javaType.containerMountPath(),
            `data` = javaType.`data`().map({ args0 -> args0 }).orElse(null),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
            volumeSubPath = javaType.volumeSubPath(),
        )
    }
}
